(function ($) {
    "use strict";
	
	var $window = $(window); 
	var $body = $('body'); 
	
	/* Preloader Effect */
	$window.load(function() {
	   $(".preloader").fadeOut(600);
    });
	
	/* slick nav */
	$('#main-menu').slicknav({prependTo:'#responsive-menu',label:'', closeOnClick:true});
		
	/* Submenu */
	$('.nav li').hover(
		function(){
			$(this).children('ul').stop().slideDown(200);
		},
		function(){
			$(this).children('ul').stop().slideUp(200);
		}
	);
	
	/* Top Menu */
	var mainnav = $("#main-nav");
	$body.attr( 'data-offset', mainnav.outerHeight() );
	$(document).on('click','#navigation ul li a, #responsive-menu ul li a',function(){
		var id = $(this).attr('href');
		var h = Math.ceil( parseFloat($(id).offset().top) );
		$('body,html').stop().animate({
			scrollTop: h - 84
		}, 800);
		return false;
	});
	
	
	/*Faq Panel*/
	$('.panel-collapse').on('show.bs.collapse', function () {
		$(this).siblings('.panel-heading').addClass('active');
	  });

	  $('.panel-collapse').on('hide.bs.collapse', function () {
		$(this).siblings('.panel-heading').removeClass('active');
	  });
	
	
	/*OwlCarousels testimonial Start*/
	$('#testimonial-carousel').owlCarousel({
		loop: false,
		items: 1,
		margin: 30,
		responsiveClass: true,
		nav: true,
		navText: [ '<i class="fa fa-long-arrow-left"></i>','<i class="fa fa-long-arrow-right"></i>'],
		dots: false,
		autoplay: true,
		autoplaySpeed: 1000
	});
	
	/*OwlCarousels Screenshot Start*/
	var $screenshots = $('#screenshot-slider-carousel');
	$screenshots.owlCarousel({
	    center: true,
		items: 3,
		loop: true,
		margin: 36,
		responsiveClass: true,
		singleItem: true,
		responsive : {
			0 : {
				items: 1
			},
			 
			768 : {
				items: 3
			},
		  },
		nav: false,
		dots: true,
		autoplay: false,
		autoplaySpeed: 2000,
		onInitialized : addCloneClassToATag
	});
	
	function addCloneClassToATag(){
		//Add class for filter to remove cloned screenshot
		$screenshots.find('.cloned a').addClass('cloned-screenshot');
		$screenshots.find('div.owl-item').each(function( index ) {
			if( ! $( this ).hasClass( "cloned" ) ){
				$( this ).addClass( "not-cloned-item" );
			}
		});
	}
		
	/* Sticky header */
	$window.scroll(function(){
    	if ($window.scrollTop() > 200) {
			$('.navbar').addClass('sticky-header');
			$body.attr('data-offset', mainnav.outerHeight());
		} else {
			$('.navbar').removeClass('sticky-header');
			$body.attr('data-offset', mainnav.outerHeight());
		}
	});
	
	/* Event for centered screenshot */
	$('.screenshot-phone').on('click', function () {
		var itemindex = -1;
		$screenshots.find('div.not-cloned-item').each(function( index ) {
			if( $( this ).hasClass( "center" ) ){
				itemindex = index;
				return false; 
			}
		});
		if(-1 != itemindex){
			$(this).next().magnificPopup('open',itemindex);
		}
	});
	
	/* Zoom screenshot */
	$('.zoom-screenshot').magnificPopup({
		delegate: '.owl-item a:not(a.cloned-screenshot)',
		type: 'image',
		closeOnContentClick: false,
		closeBtnInside: false,
		mainClass: 'mfp-with-zoom',
		image: {
			verticalFit: true,
		},
		gallery: {
			enabled: true
		},
		zoom: {
			enabled: true,
			duration: 300, // don't foget to change the duration also in CSS
			opener: function(element) {
			  return element.find('img');
			}
		}
	});
	
	/* Contact form validation */
	var $contactform=$("#contactForm");
	$contactform.validator({focus: false}).on("submit", function (event) {
		if (!event.isDefaultPrevented()) {
			event.preventDefault();
			submitForm();
		}
	});

	function submitForm(){
		/* Initiate Variables With Form Content*/
		var name = $("#name").val();
		var email = $("#email").val();
		var subject = $("#subject").val();
		var message = $("#message").val();

		$.ajax({
			type: "POST",
			url: "form-process.php",
			data: "name=" + name + "&email=" + email + "&subject=" + subject + "&message=" + message,
			success : function(text){
				if (text == "success"){
					formSuccess();
				} else {
					submitMSG(false,text);
				}
			}
		});
	}

	function formSuccess(){
		$contactform[0].reset();
		submitMSG(true, "Message Sent Successfully!")
	}

	function submitMSG(valid, msg){
		if(valid){
			var msgClasses = "h3 text-center text-success";
		} else {
			var msgClasses = "h3 text-center text-danger";
		}
		$("#msgSubmit").removeClass().addClass(msgClasses).text(msg);
	}
	/* Contact form validation end */
	
	
	/* Animate with wow js */
    new WOW().init(); 
})(jQuery);